/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.MainContainerImpl;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.core.behaviours.Behaviour;
import jade.mtp.TransportAddress;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.util.Vector;

public class PlatformManagerImpl
implements PlatformManager {
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor;
    private MainContainerImpl myMain;
    private Map nodes;
    private Map services;
    private Map replicas;
    private Map monitors;
    private String localAddr;
    private String platformID;
    private int containerNo = 1;
    private int mainContainerNo = 0;
    private int nodeNo = 1;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    PlatformManagerImpl(Profile p) throws ProfileException {
        this.myCommandProcessor = p.getCommandProcessor();
        this.myIMTPManager = p.getIMTPManager();
        this.myMain = new MainContainerImpl(p, this);
        this.nodes = new HashMap();
        this.services = new HashMap();
        this.replicas = new HashMap();
        this.monitors = new HashMap();
        this.platformID = p.getParameter("platform-id", null);
        if (this.platformID == null || this.platformID.equals("")) {
            try {
                List l = this.myIMTPManager.getLocalAddresses();
                TransportAddress localAddr = (TransportAddress)l.get(0);
                this.platformID = localAddr.getHost() + ":" + localAddr.getPort() + "/JADE";
            }
            catch (Exception e) {
                throw new ProfileException("Can't set PlatformID");
            }
        }
    }

    MainContainerImpl getMain() {
        return this.myMain;
    }

    public void setPlatformName(String name) throws IMTPException {
        this.platformID = name;
    }

    public String getPlatformName() throws IMTPException {
        return this.platformID;
    }

    public String getLocalAddress() {
        return this.localAddr;
    }

    public void setLocalAddress(String addr) {
        this.localAddr = addr;
    }

    public String addNode(NodeDescriptor dsc, Vector nodeServices, boolean propagated) throws IMTPException, ServiceException, JADESecurityException {
        String newName = this.localAddNode(dsc, nodeServices, propagated);
        if (!propagated) {
            this.broadcastAddNode(dsc, nodeServices);
        }
        return newName;
    }

    private String localAddNode(NodeDescriptor dsc, Vector nodeServices, boolean propagated) throws IMTPException, ServiceException, JADESecurityException {
        Node node = dsc.getNode();
        this.adjustName(dsc, node);
        if (!propagated) {
            GenericCommand gCmd = new GenericCommand("New-Node", null, null);
            gCmd.addParam(dsc);
            Object result = this.myCommandProcessor.processIncoming(gCmd);
            if (result instanceof JADESecurityException) {
                throw (JADESecurityException)result;
            }
            if (result instanceof Throwable) {
                this.myLogger.log(9, "Unexpected error processing NEW_NODE command. Node is " + dsc.getName());
                ((Throwable)result).printStackTrace();
            }
        }
        if (this.isLocalNode(node)) {
            this.myMain.addLocalContainer(dsc.getContainer());
        } else {
            if (this.myLogger.isLoggable(8)) {
                this.myLogger.log(8, "Adding node <" + dsc.getName() + "> to the platform");
            }
            if (dsc.getContainer() != null) {
                this.myMain.addRemoteContainer(dsc.getContainer());
            }
        }
        this.nodes.put(dsc.getName(), dsc);
        if (nodeServices != null) {
            int i = 0;
            while (i < nodeServices.size()) {
                ServiceDescriptor service = (ServiceDescriptor)nodeServices.elementAt(i);
                this.localAddSlice(service, dsc, propagated);
                ++i;
            }
        }
        if (!this.isLocalNode(node) && !propagated) {
            this.monitor(dsc);
        }
        return node.getName();
    }

    private void broadcastAddNode(NodeDescriptor dsc, Vector nodeServices) throws ServiceException {
        Object[] rr = this.replicas.values().toArray();
        int i = 0;
        while (i < rr.length) {
            PlatformManager replica = (PlatformManager)rr[i];
            try {
                replica.addNode(dsc, nodeServices, true);
            }
            catch (IMTPException imtpe) {
            }
            catch (JADESecurityException ae) {
                ae.printStackTrace();
            }
            ++i;
        }
    }

    public void removeNode(NodeDescriptor dsc, boolean propagated) throws IMTPException, ServiceException {
        this.localRemoveNode(dsc, propagated);
        if (!propagated && !this.isLocalNode(dsc.getNode())) {
            this.broadcastRemoveNode(dsc);
        }
    }

    private void localRemoveNode(NodeDescriptor dsc, boolean propagated) throws ServiceException {
        NodeFailureMonitor failureMonitor;
        dsc = this.adjustDescriptor(dsc);
        Node node = dsc.getNode();
        Object[] allServiceKeys = this.services.keySet().toArray();
        int i = 0;
        while (i < allServiceKeys.length) {
            String serviceKey = (String)allServiceKeys[i];
            this.localRemoveSlice(serviceKey, dsc.getName(), propagated);
            ++i;
        }
        if (this.isLocalNode(node)) {
            this.myMain.removeLocalContainer(dsc.getContainer());
        } else {
            if (this.myLogger.isLoggable(8)) {
                this.myLogger.log(8, "Removing node <" + dsc.getName() + "> from the platform");
            }
            if (dsc.getContainer() != null) {
                this.myMain.removeRemoteContainer(dsc.getContainer());
            }
        }
        this.nodes.remove(dsc.getName());
        Node parent = dsc.getParentNode();
        if (parent != null && (failureMonitor = (NodeFailureMonitor)this.monitors.get(parent.getName())) != null) {
            failureMonitor.removeChild(node);
        }
        this.monitors.remove(node.getName());
        if (!propagated) {
            GenericCommand gCmd = new GenericCommand("Dead-Node", null, null);
            gCmd.addParam(dsc);
            Object result = this.myCommandProcessor.processIncoming(gCmd);
            if (result instanceof Throwable) {
                this.myLogger.log(9, "Unexpected error processing DEAD_NODE command. Node is " + dsc.getName());
                ((Throwable)result).printStackTrace();
            }
        }
    }

    private void broadcastRemoveNode(NodeDescriptor dsc) throws ServiceException {
        Object[] rr = this.replicas.values().toArray();
        int i = 0;
        while (i < rr.length) {
            PlatformManager replica = (PlatformManager)rr[i];
            try {
                replica.removeNode(dsc, true);
            }
            catch (IMTPException imtpe) {
                // empty catch block
            }
            ++i;
        }
    }

    public void addSlice(ServiceDescriptor service, NodeDescriptor dsc, boolean propagated) throws IMTPException, ServiceException {
        this.localAddSlice(service, dsc, propagated);
        if (!propagated) {
            this.broadcastAddSlice(service, dsc);
        }
    }

    private void localAddSlice(ServiceDescriptor serviceDsc, NodeDescriptor dsc, boolean propagated) throws IMTPException, ServiceException {
        Behaviour b;
        Service service = serviceDsc.getService();
        String serviceKey = service.getName();
        ServiceEntry e = (ServiceEntry)this.services.get(serviceKey);
        if (e == null) {
            if (this.myLogger.isLoggable(7)) {
                this.myLogger.log(7, "Adding entry for service <" + serviceKey + ">");
            }
            e = new ServiceEntry(service);
            this.services.put(serviceKey, e);
        }
        if (this.myLogger.isLoggable(7)) {
            this.myLogger.log(7, "Adding slice for service <" + serviceKey + "> on node <" + dsc.getName() + ">");
        }
        Node node = dsc.getNode();
        Service.Slice slice = null;
        slice = service.getHorizontalInterface() != null ? this.myIMTPManager.createSliceProxy(serviceKey, service.getHorizontalInterface(), node) : new SliceProxy(service, node);
        String sliceKey = node.getName();
        e.addSlice(sliceKey, slice, node);
        if (this.isLocalNode(node) && (b = service.getAMSBehaviour()) != null) {
            this.myMain.installAMSBehaviour(b);
        }
        if (!propagated) {
            GenericCommand gCmd = new GenericCommand("New-Slice", serviceKey, null);
            gCmd.addParam(sliceKey);
            Object result = this.myCommandProcessor.processIncoming(gCmd);
            if (result instanceof Throwable) {
                this.myLogger.log(9, "Unexpected error processing NEW_SLICE command. Service is " + serviceKey + " node is " + sliceKey);
                ((Throwable)result).printStackTrace();
            }
        }
    }

    private void broadcastAddSlice(ServiceDescriptor service, NodeDescriptor dsc) throws ServiceException {
        Object[] rr = this.replicas.values().toArray();
        int i = 0;
        while (i < rr.length) {
            PlatformManager replica = (PlatformManager)rr[i];
            try {
                replica.addSlice(service, dsc, true);
            }
            catch (IMTPException imtpe) {
                // empty catch block
            }
            ++i;
        }
    }

    public void removeSlice(String serviceKey, String sliceKey, boolean propagated) throws IMTPException, ServiceException {
        this.localRemoveSlice(serviceKey, sliceKey, propagated);
        if (!propagated) {
            this.broadcastRemoveSlice(serviceKey, sliceKey);
        }
    }

    private void localRemoveSlice(String serviceKey, String sliceKey, boolean propagated) throws ServiceException {
        ServiceEntry e = (ServiceEntry)this.services.get(serviceKey);
        if (e != null) {
            Behaviour b;
            NodeDescriptor dsc;
            Service svc;
            if (e.removeSlice(sliceKey) != null && this.myLogger.isLoggable(7)) {
                this.myLogger.log(7, "Removing slice for service <" + serviceKey + "> on node <" + sliceKey + ">");
            }
            if ((svc = e.getService()) instanceof BaseService) {
                ((BaseService)svc).clearCachedSlice(sliceKey);
            }
            if ((dsc = this.getDescriptor(sliceKey)) != null && this.isLocalNode(dsc.getNode()) && (b = e.getService().getAMSBehaviour()) != null) {
                this.myMain.uninstallAMSBehaviour(b);
            }
            if (!propagated) {
                GenericCommand gCmd = new GenericCommand("Dead-Slice", serviceKey, null);
                gCmd.addParam(sliceKey);
                Object result = this.myCommandProcessor.processIncoming(gCmd);
                if (result instanceof Throwable) {
                    this.myLogger.log(9, "Unexpected error processing DEAD_SLICE command. Service is " + serviceKey + " node is " + sliceKey);
                    ((Throwable)result).printStackTrace();
                }
            }
        }
    }

    private void broadcastRemoveSlice(String serviceKey, String sliceKey) throws ServiceException {
        Object[] rr = this.replicas.values().toArray();
        int i = 0;
        while (i < rr.length) {
            PlatformManager replica = (PlatformManager)rr[i];
            try {
                replica.removeSlice(serviceKey, sliceKey, true);
            }
            catch (IMTPException imtpe) {
                // empty catch block
            }
            ++i;
        }
    }

    public void addReplica(String newAddr, boolean propagated) throws IMTPException, ServiceException {
        PlatformManager newReplica = this.myIMTPManager.getPlatformManagerProxy(newAddr);
        this.localAddReplica(newReplica, propagated);
        if (!propagated) {
            this.broadcastAddReplica(newAddr);
        }
        this.replicas.put(newReplica.getLocalAddress(), newReplica);
    }

    private void localAddReplica(PlatformManager newReplica, boolean propagated) throws IMTPException, ServiceException {
        if (this.myLogger.isLoggable(8)) {
            this.myLogger.log(8, "Adding replica <" + newReplica.getLocalAddress() + "> to the platform");
        }
        if (!propagated) {
            List infos = this.getAllNodesInfo();
            Iterator it = infos.iterator();
            while (it.hasNext()) {
                NodeInfo info = (NodeInfo)it.next();
                try {
                    newReplica.addNode(info.getNodeDescriptor(), info.getServices(), true);
                }
                catch (JADESecurityException ae) {
                    ae.printStackTrace();
                }
            }
            Object[] rr = this.replicas.values().toArray();
            int i = 0;
            while (i < rr.length) {
                PlatformManager replica = (PlatformManager)rr[i];
                newReplica.addReplica(replica.getLocalAddress(), true);
                ++i;
            }
        }
        GenericCommand gCmd = new GenericCommand("New-Replica", null, null);
        gCmd.addParam(newReplica.getLocalAddress());
        Object result = this.myCommandProcessor.processIncoming(gCmd);
        if (result instanceof Throwable) {
            this.myLogger.log(9, "Unexpected error processing NEW_REPLICA command. Replica address is " + newReplica.getLocalAddress());
            ((Throwable)result).printStackTrace();
        }
    }

    private void broadcastAddReplica(String newAddr) throws ServiceException {
        Object[] rr = this.replicas.values().toArray();
        int i = 0;
        while (i < rr.length) {
            PlatformManager replica = (PlatformManager)rr[i];
            try {
                replica.addReplica(newAddr, true);
            }
            catch (IMTPException imtpe) {
                // empty catch block
            }
            ++i;
        }
    }

    public void removeReplica(String address, boolean propagated) throws IMTPException, ServiceException {
        this.localRemoveReplica(address, propagated);
        if (!propagated) {
            this.broadcastRemoveReplica(address);
        }
    }

    private void localRemoveReplica(String address, boolean propagated) throws ServiceException {
        if (this.myLogger.isLoggable(8)) {
            this.myLogger.log(8, "Removing replica <" + address + "> from the platform");
        }
        this.replicas.remove(address);
        if (!propagated) {
            Object[] allNodes = this.nodes.values().toArray();
            int i = 0;
            while (i < allNodes.length) {
                Node n;
                NodeDescriptor dsc = (NodeDescriptor)allNodes[i];
                if (dsc.getParentNode() == null && !(n = dsc.getNode()).hasPlatformManager()) {
                    try {
                        n.platformManagerDead(address, this.getLocalAddress());
                    }
                    catch (IMTPException imtpe) {
                        this.removeTerminatedNode(n);
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < allNodes.length) {
                NodeDescriptor dsc = (NodeDescriptor)allNodes[i2];
                if (dsc.getParentNode() != null) {
                    Node n = dsc.getNode();
                    try {
                        n.platformManagerDead(address, this.getLocalAddress());
                    }
                    catch (IMTPException imtpe) {
                        this.removeTerminatedNode(n);
                    }
                }
                ++i2;
            }
        }
        GenericCommand gCmd = new GenericCommand("Dead-Replica", null, null);
        gCmd.addParam(address);
        Object result = this.myCommandProcessor.processIncoming(gCmd);
        if (result instanceof Throwable) {
            this.myLogger.log(9, "Unexpected error processing DEAD_REPLICA command. Replica address is " + address);
            ((Throwable)result).printStackTrace();
        }
    }

    private void broadcastRemoveReplica(String address) throws ServiceException {
        Object[] rr = this.replicas.values().toArray();
        int i = 0;
        while (i < rr.length) {
            PlatformManager replica = (PlatformManager)rr[i];
            try {
                replica.removeReplica(address, true);
            }
            catch (IMTPException imtpe) {
                // empty catch block
            }
            ++i;
        }
    }

    public void adopt(Node n, Node[] children) throws IMTPException {
        String name = n.getName();
        NodeDescriptor dsc = this.getDescriptor(name);
        if (dsc != null) {
            this.monitor(dsc);
            this.myLogger.log(8, "Node <" + n.getName() + "> adopted");
        } else {
            this.myLogger.log(9, "NO descriptor found for node <" + n.getName() + "> requesting adoption. Ignore...");
        }
    }

    public void ping() throws IMTPException {
    }

    public Service.Slice findSlice(String serviceKey, String sliceKey) throws IMTPException, ServiceException {
        ServiceEntry e = (ServiceEntry)this.services.get(serviceKey);
        if (e == null) {
            return null;
        }
        if (CaseInsensitiveString.equalsIgnoreCase(sliceKey, "$$$Main-Slice$$$")) {
            sliceKey = this.myIMTPManager.getLocalNode().getName();
        }
        return e.getSlice(sliceKey);
    }

    public Vector findAllSlices(String serviceKey) throws IMTPException, ServiceException {
        ServiceEntry e = (ServiceEntry)this.services.get(serviceKey);
        if (e == null) {
            return null;
        }
        return e.getSlices();
    }

    NodeDescriptor getDescriptor(String name) {
        return (NodeDescriptor)this.nodes.get(name);
    }

    void shutdown() {
    }

    private boolean isLocalNode(Node n) {
        try {
            return this.myIMTPManager.getLocalNode().equals(n);
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
            return false;
        }
    }

    private NodeDescriptor adjustDescriptor(NodeDescriptor dsc) {
        NodeDescriptor originalDsc = (NodeDescriptor)this.nodes.get(dsc.getName());
        if (originalDsc != null) {
            ContainerID cid = originalDsc.getContainer();
            if (cid != null) {
                dsc = new NodeDescriptor(cid, dsc.getNode());
            }
            dsc.setParentNode(originalDsc.getParentNode());
        }
        return dsc;
    }

    private List getAllNodesInfo() {
        Object[] allNodes = this.nodes.values().toArray();
        ArrayList infos = new ArrayList(allNodes.length);
        int i = 0;
        while (i < allNodes.length) {
            NodeDescriptor nodeDsc = (NodeDescriptor)allNodes[i];
            infos.add(new NodeInfo(nodeDsc));
            ++i;
        }
        HashMap nodeServices = new HashMap();
        Object[] allServices = this.services.values().toArray();
        int j = 0;
        while (j < allServices.length) {
            ServiceEntry e = (ServiceEntry)allServices[j];
            Node[] serviceNodes = e.getNodes();
            int i2 = 0;
            while (i2 < serviceNodes.length) {
                String nodeName = serviceNodes[i2].getName();
                Vector<ServiceDescriptor> v = (Vector<ServiceDescriptor>)nodeServices.get(nodeName);
                if (v == null) {
                    v = new Vector<ServiceDescriptor>();
                    nodeServices.put(nodeName, v);
                }
                Service svc = e.getService();
                v.addElement(new ServiceDescriptor(svc.getName(), svc));
                ++i2;
            }
            ++j;
        }
        Iterator it = infos.iterator();
        while (it.hasNext()) {
            NodeInfo ni = (NodeInfo)it.next();
            Vector v = (Vector)nodeServices.get(ni.getNodeDescriptor().getName());
            ni.setServices(v);
        }
        return infos;
    }

    private Node[] getChildren(String name) {
        ArrayList children = new ArrayList();
        Object[] allNodes = this.nodes.values().toArray();
        int i = 0;
        while (i < allNodes.length) {
            NodeDescriptor dsc = (NodeDescriptor)allNodes[i];
            Node parent = dsc.getParentNode();
            if (parent != null && name.equals(parent.getName())) {
                children.add(dsc.getNode());
            }
            ++i;
        }
        Node[] childrenArray = new Node[children.size()];
        int i2 = 0;
        while (i2 < childrenArray.length) {
            childrenArray[i2] = (Node)children.get(i2);
            ++i2;
        }
        return childrenArray;
    }

    private void adjustName(NodeDescriptor dsc, Node node) {
        ContainerID cid = dsc.getContainer();
        if (cid != null) {
            this.adjustContainerName(node, cid);
            node.setName(cid.getName());
            dsc.setName(cid.getName());
        } else {
            if (node.getName() == null || node.getName().equals("No-Name")) {
                String name = null;
                NodeDescriptor old = null;
                do {
                    name = "Aux-Node-" + this.nodeNo;
                    ++this.nodeNo;
                } while ((old = (NodeDescriptor)this.nodes.get(name)) != null);
                node.setName(name);
            }
            dsc.setName(node.getName());
        }
    }

    private void adjustContainerName(Node n, ContainerID cid) {
        String name = null;
        NodeDescriptor old = null;
        if (cid.getName() == null || cid.getName().equals("No-Name")) {
            if (n.hasPlatformManager()) {
                do {
                    name = "Main-Container" + (this.mainContainerNo == 0 ? "" : "-" + this.mainContainerNo);
                    ++this.mainContainerNo;
                } while ((old = (NodeDescriptor)this.nodes.get(name)) != null);
            } else {
                do {
                    name = "Container-" + this.containerNo;
                    ++this.containerNo;
                } while ((old = (NodeDescriptor)this.nodes.get(name)) != null);
            }
            cid.setName(name);
        } else {
            name = cid.getName();
            int cnt = 1;
            old = (NodeDescriptor)this.nodes.get(name);
            while (old != null) {
                name = cid.getName() + '-' + cnt;
                ++cnt;
                old = (NodeDescriptor)this.nodes.get(name);
            }
            cid.setName(name);
        }
    }

    private void monitor(NodeDescriptor dsc) {
        boolean needMonitor = true;
        Node node = dsc.getNode();
        Node parent = dsc.getParentNode();
        if (parent != null) {
            if (this.isLocalNode(parent)) {
                needMonitor = false;
            } else {
                NodeFailureMonitor failureMonitor = (NodeFailureMonitor)this.monitors.get(parent.getName());
                if (failureMonitor != null) {
                    failureMonitor.addChild(node);
                    if (this.myLogger.isLoggable(7)) {
                        this.myLogger.log(8, "Node <" + node.getName() + "> added as child of node " + parent.getName());
                    }
                    needMonitor = false;
                }
            }
        }
        if (needMonitor) {
            this.monitor(node);
        }
    }

    private NodeFailureMonitor monitor(Node target) {
        NodeEventListener listener = new NodeEventListener(){

            public void nodeAdded(Node n) {
                PlatformManagerImpl.this.myLogger.log(8, "--- Node <" + n.getName() + "> ALIVE ---");
            }

            public void nodeRemoved(Node n) {
                PlatformManagerImpl.this.removeTerminatedNode(n);
            }

            public void nodeUnreachable(Node n) {
                PlatformManagerImpl.this.myLogger.log(9, "--- Node <" + n.getName() + "> UNREACHABLE ---");
            }

            public void nodeReachable(Node n) {
                PlatformManagerImpl.this.myLogger.log(8, "--- Node <" + n.getName() + "> REACHABLE ---");
            }
        };
        NodeFailureMonitor failureMonitor = NodeFailureMonitor.getFailureMonitor();
        failureMonitor.start(target, listener);
        this.monitors.put(target.getName(), failureMonitor);
        return failureMonitor;
    }

    private void removeTerminatedNode(Node n) {
        if (this.myLogger.isLoggable(8)) {
            this.myLogger.log(8, "--- Node <" + n.getName() + "> TERMINATED ---");
        }
        try {
            this.removeNode(new NodeDescriptor(n), false);
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
    }

    Map getServicesMap() {
        return this.services;
    }

    private class NodeInfo {
        private NodeDescriptor nodeDsc;
        private Vector services;

        private NodeInfo(NodeDescriptor nd) {
            this.nodeDsc = nd;
        }

        public NodeDescriptor getNodeDescriptor() {
            return this.nodeDsc;
        }

        public Vector getServices() {
            return this.services;
        }

        public void setServices(Vector ss) {
            this.services = ss;
        }
    }

    class SliceEntry {
        private Service.Slice mySlice;
        private Node myNode;

        public SliceEntry(Service.Slice s, Node n) {
            this.mySlice = s;
            this.myNode = n;
        }

        public Service.Slice getSlice() {
            return this.mySlice;
        }

        public Node getNode() {
            return this.myNode;
        }
    }

    class ServiceEntry {
        private Service myService;
        private Map slices;

        public ServiceEntry(Service s) {
            this.myService = s;
            this.slices = new HashMap();
        }

        public void addSlice(String name, Service.Slice s, Node n) {
            SliceEntry e = new SliceEntry(s, n);
            this.slices.put(name, e);
        }

        public Service.Slice removeSlice(String name) {
            SliceEntry e = (SliceEntry)this.slices.remove(name);
            if (e == null) {
                return null;
            }
            return e.getSlice();
        }

        public Vector getSlices() {
            Iterator sliceEntries = this.slices.values().iterator();
            Vector<Service.Slice> result = new Vector<Service.Slice>();
            while (sliceEntries.hasNext()) {
                SliceEntry e = (SliceEntry)sliceEntries.next();
                result.addElement(e.getSlice());
            }
            return result;
        }

        public Service.Slice getSlice(String name) {
            SliceEntry e = (SliceEntry)this.slices.get(name);
            if (e == null) {
                return null;
            }
            return e.getSlice();
        }

        public Node[] getNodes() {
            Object[] sliceEntries = this.slices.values().toArray();
            Node[] result = new Node[sliceEntries.length];
            int i = 0;
            while (i < result.length) {
                SliceEntry e = (SliceEntry)sliceEntries[i];
                result[i] = e.getNode();
                ++i;
            }
            return result;
        }

        public Node getNode(String name) {
            SliceEntry e = (SliceEntry)this.slices.get(name);
            if (e == null) {
                return null;
            }
            return e.getNode();
        }

        public void setService(Service svc) {
            this.myService = svc;
        }

        public Service getService() {
            return this.myService;
        }

        Map getSlicesMap() {
            return this.slices;
        }
    }
}

